   <?php


/**
 * Template Name: Home Page
 * 
 * The template for displaying the home page
 */

get_header(); // This loads the header


?>
   <div class="body-overlay"></div>
        
    <!-- main area start -->
    <main>
        <!-- hero start -->
        <section class="hero hero-style hero-one pos-rel">
            <div class="container-fluid p-0">
                <div class="row g-0">
                    <div class="col-lg-6">
                        <div class="xb-hero_content">
                            <div class="sec-title">
                                <h2 class="title mb-15 wow fadeInUp" data-wow-delay="0ms" data-wow-duration="400ms">Business challenges solved smartly</h2>
                                <p class="content wow fadeInUp" data-wow-delay="150ms" data-wow-duration="400ms">We provide smart, tailored solutions to help businesses overcome challenges, optimize operations, and achieve lasting growth.</p>
                            </div>
                            <div class="xb-hero-btn mt-35 wow fadeInUp" data-wow-delay="300ms" data-wow-duration="400ms">
                                <a class="thm-btn arrow_hover_effect" href="contact.html">
                                    <span class="btn_label" data-text="Get free consulting">Get free consulting</span>
                                    <span class="xb-icon">
                                        <span class="xb-arrow">
                                            <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                            <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                            <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                            <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                            <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                            <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                            <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                            <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                            </svg>
                                            <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                            <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                            <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                            <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                            <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                            <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                            <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                            <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                            </svg>
                                        </span>
                                    </span>
                                </a>
                            </div>
                        </div>
                        <div class="xb_hero_big_text">
                            <div class="wow fadeInRight" data-wow-delay="350ms" data-wow-duration="400ms">
                                <h2 class="text">BUSINESS</h2>
                            </div>
                        </div>
                        <p class="xb-hero-content">Planning and execution that transforms vision into measurable, lasting results.</p>
                    </div>
                    <div class="col-lg-6 order-lg-first">
                        <div class="xb-hero-img">
    <img 
        src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/hero/hero-img01.jpg" 
        alt="Hero Image"
        class="hero-main-img"
    >

    <div class="xb-badge wow zoomIn" data-wow-delay="0ms" data-wow-duration="400ms">
        <div class="img">
            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/hero/badge-text.png" alt="badge-text">
        </div>
        <div class="badge-logo">
            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/hero/badge-logo.svg" alt="badge">
        </div>
    </div>
</div>

                    </div>
                </div>
                <div class="hero-circle-shape">
                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/shape/circle-shape.png" alt="circle image">
                </div>
            </div>
        </section>
        <!-- hero end -->

        <!-- about start -->
        <section class="about xb-about-section bg-linear pos-rel z-1 pt-145 pb-70">
            <div class="container-fluid p-0">
                <div class="xb-about-wrap mlr-70">
                    <div class="row">
                        <div class="col-lg-8 col-md-8">
                            <div class="sec-title about-sec-title ul_li">
                                <span class="sub-title clr-white">Who we are</span>
                                <div class="xb-holder">
                                    <h2 class="title xb-text-reveal title-font-65 clr-white mb-25">An award-winning business consulting, helping companies succeed since 1994</h2>
                                    <p class="content clr-white">An award-winning business consulting firm, dedicated to delivering expert strategies, innovative solutions, and measurable results that help companies overcome challenges, seize new opportunities and achieve sustainable success—proudly serving businesses since 1994.</p>
                                    <div class="xb-about-btn mt-40">
                                        <a class="thm-btn arrow_hover_effect btn-bg" href="about.html">
                                            <span class="btn_label" data-text="Know more about us">Know more about us</span>
                                            <span class="xb-icon">
                                                <span class="xb-arrow">
                                                    <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                                    <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                    <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                                    <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                                    <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                                    <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                                    <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                                    <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                    </svg>
                                                    <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                                    <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                    <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                                    <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                                    <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                                    <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                                    <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                                    <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                    </svg>
                                                </span>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4">
                            <div class="xb-about-video xb-video wow zoomIn" data-wow-delay="0ms" data-wow-duration="600ms">
                                <video loop="" muted="" playsinline="" autoplay="" poster="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/hero/gradient_bg.jpg">
                                    <source src="https://www.pexels.com/download/video/7552653/">
                                </video>
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-end">
                        <div class="col-xl-8 col-lg-9">
                            <div class="xb-countdown-wrap">
                                <div class="xb-countdown-item">
                                    <h3 class="xb-item--number xb-odm">
                                        <span class="xbo" data-count="80">00</span><span class="suffix">+</span>
                                    </h3>
                                    <p class="xb-item--text">Presence in 80+ countries</p>
                                </div>
                                <div class="xb-countdown-item">
                                    <h3 class="xb-item--number xb-odm">
                                        <span class="xbo" data-count="10,000,000">00</span><span class="suffix"></span>
                                    </h3>
                                    <p class="xb-item--text">10 Million engaged business decision-makers</p>
                                </div>
                                <div class="xb-countdown-item">
                                    <h3 class="xb-item--number xb-odm">
                                        <span class="xbo" data-count="82.4">00</span><span class="suffix">%</span>
                                    </h3>
                                    <p class="xb-item--text">82.4% Average annual client growth rate</p>
                                </div>
                                <div class="xb-countdown-item">
                                    <h3 class="xb-item--number xb-odm">
                                        <span class="xbo" data-count="9,700">00</span><span class="suffix"></span>
                                    </h3>
                                    <p class="xb-item--text">9,700 successful projects delivered</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="xb-about-line-inner">
                    <div class="line">
                        <div class="dot"><span></span></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- about end -->

        <!-- service start -->
        <section class="service pt-140 pb-150">
            <div class="container-fluid p-0">
                <div class="mlr-70">
                    <div class="xb-service-top sec-title-wrap ul_li_between mb-55">
                        <div class="sec-title ul_li align-items-center">
                            <span class="sub-title">Our main services</span>
                            <h2 class="title xb-text-reveal">Our services</h2>
                        </div>
                        <p class="content">We provide tailored business consulting services designed to streamline operations, enhance performance, and sustainable growth, helping companies.</p>
                    </div>
                    <div class="xb-service-wrapper">
                        <div class="xb-service-item">
                            <div class="row mt-none-30">
                                <div class="col-lg-6 mt-30">
                                    <div class="xb-service-inner arrow_hover_effect">
                                        <h2 class="xb-item--title"><a href="service-details.html">Business strategy development.</a></h2>
                                        <ul class="xb-item--list list-unstyled">
                                            <li><a href="#!">Competitive positioning</a></li>
                                            <li><a href="#!">Strategic planning</a></li>
                                            <li><a href="#!">Growth roadmapping</a></li>
                                            <li><a href="#!">Business model innovation</a></li>
                                            <li><a href="#!">Market entry strategies</a></li>
                                        </ul>
                                        <a class="xb-item--icon" href="service-details.html">
                                            <div class="xb-arrow">
                                                <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                <rect x="9.29785" y="6.87231" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87231)" fill="#191B21" />
                                                <rect x="13.1558" y="7.19043" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19043)" fill="#191B21" />
                                                <rect x="17.0139" y="7.50903" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50903)" fill="#191B21" />
                                                <rect x="20.5535" y="11.6853" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6853)" fill="#191B21" />
                                                <rect x="20.2356" y="15.5442" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5442)" fill="#191B21" />
                                                <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                </svg>
                                                <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                <rect x="9.29785" y="6.87231" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87231)" fill="#191B21" />
                                                <rect x="13.1558" y="7.19043" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19043)" fill="#191B21" />
                                                <rect x="17.0139" y="7.50903" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50903)" fill="#191B21" />
                                                <rect x="20.5535" y="11.6853" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6853)" fill="#191B21" />
                                                <rect x="20.2356" y="15.5442" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5442)" fill="#191B21" />
                                                <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                </svg>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="col-lg-6 mt-30">
                                    <div class="xb-service-img">
                                        <a href="service-details.html" class="xb-img">
                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/service/img01.jpg" alt="image">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="xb-service-item">
                            <div class="row mt-none-30">
                                <div class="col-lg-6 mt-30">
                                    <div class="xb-service-inner arrow_hover_effect">
                                        <h2 class="xb-item--title"><a href="service-details.html">Market & competitor analysis.</a></h2>
                                        <ul class="xb-item--list list-unstyled">
                                            <li><a href="#!">Market research</a></li>
                                            <li><a href="#!">SWOT analysis</a></li>
                                            <li><a href="#!">Industry trends analysis</a></li>
                                            <li><a href="#!">Pricing strategy</a></li>
                                            <li><a href="#!">Customer segmentation</a></li>
                                            <li><a href="#!">Gap analysis</a></li>
                                        </ul>
                                        <a class="xb-item--icon" href="service-details.html">
                                            <div class="xb-arrow">
                                                <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                <rect x="9.29785" y="6.87231" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87231)" fill="#191B21" />
                                                <rect x="13.1558" y="7.19043" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19043)" fill="#191B21" />
                                                <rect x="17.0139" y="7.50903" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50903)" fill="#191B21" />
                                                <rect x="20.5535" y="11.6853" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6853)" fill="#191B21" />
                                                <rect x="20.2356" y="15.5442" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5442)" fill="#191B21" />
                                                <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                </svg>
                                                <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                <rect x="9.29785" y="6.87231" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87231)" fill="#191B21" />
                                                <rect x="13.1558" y="7.19043" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19043)" fill="#191B21" />
                                                <rect x="17.0139" y="7.50903" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50903)" fill="#191B21" />
                                                <rect x="20.5535" y="11.6853" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6853)" fill="#191B21" />
                                                <rect x="20.2356" y="15.5442" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5442)" fill="#191B21" />
                                                <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                </svg>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="col-lg-6 mt-30">
                                    <div class="xb-service-img">
                                        <a href="service-details.html" class="xb-img">
                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/service/img02.jpg" alt="image">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="xb-service-item">
                            <div class="row mt-none-30">
                                <div class="col-lg-6 mt-30">
                                    <div class="xb-service-inner arrow_hover_effect">
                                        <h2 class="xb-item--title"><a href="service-details.html">Project management consulting.</a></h2>
                                        <ul class="xb-item--list list-unstyled">
                                            <li><a href="#!">Resource allocation</a></li>
                                            <li><a href="#!">Budget management</a></li>
                                            <li><a href="#!">Stakeholder communication</a></li>
                                            <li><a href="#!">Performance monitoring</a></li>
                                            <li><a href="#!">Change management</a></li>
                                            <li><a href="#!">Quality control</a></li>
                                        </ul>
                                        <a class="xb-item--icon" href="service-details.html">
                                            <div class="xb-arrow">
                                                <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                <rect x="9.29785" y="6.87231" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87231)" fill="#191B21" />
                                                <rect x="13.1558" y="7.19043" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19043)" fill="#191B21" />
                                                <rect x="17.0139" y="7.50903" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50903)" fill="#191B21" />
                                                <rect x="20.5535" y="11.6853" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6853)" fill="#191B21" />
                                                <rect x="20.2356" y="15.5442" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5442)" fill="#191B21" />
                                                <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                </svg>
                                                <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                <rect x="9.29785" y="6.87231" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87231)" fill="#191B21" />
                                                <rect x="13.1558" y="7.19043" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19043)" fill="#191B21" />
                                                <rect x="17.0139" y="7.50903" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50903)" fill="#191B21" />
                                                <rect x="20.5535" y="11.6853" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6853)" fill="#191B21" />
                                                <rect x="20.2356" y="15.5442" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5442)" fill="#191B21" />
                                                <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                </svg>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="col-lg-6 mt-30">
                                    <div class="xb-service-img">
                                        <a href="service-details.html" class="xb-img">
                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/service/img03.jpg" alt="image">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="xb-service-item">
                            <div class="row mt-none-30">
                                <div class="col-lg-6 mt-30">
                                    <div class="xb-service-inner arrow_hover_effect">
                                        <h2 class="xb-item--title"><a href="service-details.html">Financial planning & advisory.</a></h2>
                                        <ul class="xb-item--list list-unstyled">
                                            <li><a href="#!">Investment analysis</a></li>
                                            <li><a href="#!">Financial risk assessment</a></li>
                                            <li><a href="#!">Tax planning guidance</a></li>
                                            <li><a href="#!">Financial reporting & compliance</a></li>
                                            <li><a href="#!">Capital raising advisory</a></li>
                                        </ul>
                                        <a class="xb-item--icon" href="service-details.html">
                                            <div class="xb-arrow">
                                                <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                <rect x="9.29785" y="6.87231" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87231)" fill="#191B21" />
                                                <rect x="13.1558" y="7.19043" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19043)" fill="#191B21" />
                                                <rect x="17.0139" y="7.50903" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50903)" fill="#191B21" />
                                                <rect x="20.5535" y="11.6853" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6853)" fill="#191B21" />
                                                <rect x="20.2356" y="15.5442" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5442)" fill="#191B21" />
                                                <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                </svg>
                                                <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                <rect x="9.29785" y="6.87231" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87231)" fill="#191B21" />
                                                <rect x="13.1558" y="7.19043" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19043)" fill="#191B21" />
                                                <rect x="17.0139" y="7.50903" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50903)" fill="#191B21" />
                                                <rect x="20.5535" y="11.6853" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6853)" fill="#191B21" />
                                                <rect x="20.2356" y="15.5442" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5442)" fill="#191B21" />
                                                <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                </svg>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="col-lg-6 mt-30">
                                    <div class="xb-service-img">
                                        <a href="service-details.html" class="xb-img">
                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/service/img04.jpg" alt="image">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="xb-service-btn text-center mt-60 wow fadeInUp" data-wow-delay="0ms" data-wow-duration="600ms">
                            <a class="thm-btn arrow_hover_effect" href="service.html">
                                <span class="btn_label" data-text="See more services">See more services</span>
                                <span class="xb-icon">
                                    <span class="xb-arrow">
                                        <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                        <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                        <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                        <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                        <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                        <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                        <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                        <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                        </svg>
                                        <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                        <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                        <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                        <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                        <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                        <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                        <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                        <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                        </svg>
                                    </span>
                                </span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- service end -->

        <!-- feature start -->
        <section class="feature pos-rel z-1 pt-140 bg-linear">
            <div class="container-fluid p-0">
                <div class="xb-feature-top sec-title-wrap mlr-70">
                    <div class="sec-title ul_li mb-95">
                        <span class="sub-title clr-white">Why Choose Us</span>
                        <div class="xb-holder">
                            <h2 class="title xb-text-reveal clr-white">Why industry leaders choose our firm for lasting success</h2>
                            <div class="xb-feature-btn mt-45">
                                <a class="thm-btn arrow_hover_effect btn-bg" href="contact.html">
                                    <span class="btn_label" data-text="Get free consulting">Get free consulting</span>
                                    <span class="xb-icon">
                                        <span class="xb-arrow">
                                            <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                            <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                            <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                            <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                            <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                            <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                            <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                            <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                            </svg>
                                            <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                            <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                            <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                            <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                            <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                            <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                            <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                            <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                            </svg>
                                        </span>
                                    </span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="xb-feature-wrap">
                    <div class="xb-feature-item">
                        <div class="xb-item--icon">
                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/feature-icon01.gif" alt="icon">
                        </div>
                        <h3 class="xb-item--title">Faster business growth</h3>
                        <p class="xb-item--content">Drive faster business growth with smart strategies that deliver real results.</p>
                    </div>
                    <div class="xb-feature-item">
                        <div class="xb-item--icon"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/feature-icon02.gif" alt="icon"></div>
                        <h3 class="xb-item--title">Strategy that delivers</h3>
                        <p class="xb-item--content">A focused strategy built to drive meaningful results, helping your business achieve.</p>
                    </div>
                    <div class="xb-feature-item">
                        <div class="xb-item--icon"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/feature-icon03.gif" alt="icon"></div>
                        <h3 class="xb-item--title">Lower costs, higher value</h3>
                        <p class="xb-item--content">We help reduce costs while maximizing value, improving efficiency to boost.</p>
                    </div>
                    <div class="xb-feature-item">
                        <div class="xb-item--icon"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/feature-icon04.gif" alt="icon"></div>
                        <h3 class="xb-item--title">Reliable business results</h3>
                        <p class="xb-item--content">We deliver reliable results through proven strategies, helping your business grow.</p>
                    </div>
                </div>
                <div class="xb-feature-shape">
                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/globe.gif" alt="gif">
                </div>
            </div>
        </section>
        <!-- feature end -->

        <!-- brand start -->
        <section class="brand">
            <div class="container-fluid p-0">
                <div class="xb-brand-wrap">
                    <div class="row g-0 align-items-center">
                        <div class="col-lg-3">
                            <div class="sec-title brand-sec-title">
                                <span class="sub-title clr-white">Trusted by the best in the business</span>
                            </div>
                        </div>
                        <div class="col-lg-9">
                            <ul class="xb-brand-item-list list-unstyled marquee-left">
                                <li class="item">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/brand/logo01.png" alt="brand logo">
                                </li>
                                <li class="item">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/brand/logo02.png" alt="brand logo">
                                </li>
                                <li class="item">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/brand/logo03.png" alt="brand logo">
                                </li>
                                <li class="item">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/brand/logo04.png" alt="brand logo">
                                </li>
                                <li class="item">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/brand/logo05.png" alt="brand logo">
                                </li>
                                <li class="item">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/brand/logo06.png" alt="brand logo">
                                </li>
                                <li class="item">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/brand/logo07.png" alt="brand logo">
                                </li>
                                <li class="item">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/brand/logo08.png" alt="brand logo">
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- brand end -->

        <!-- project start-->
        <section class="project pt-140">
            <div class="container-fluid p-0">
                <div class="xb-projext-wrapper mlr-70">
                    <div class="xb-project-top sec-title-wrap ul_li_between mb-65">
                        <div class="sec-title ul_li align-items-center">
                            <span class="sub-title">Our case studies</span>
                            <h2 class="title xb-text-reveal">Explore recent case studies</h2>
                        </div>
                        <div class="xb-project-btn">
                            <a class="thm-btn arrow_hover_effect" href="project.html">
                                <span class="btn_label" data-text="View all case studies">View all case studies</span>
                                <span class="xb-icon">
                                    <span class="xb-arrow">
                                        <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                        <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                        <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                        <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                        <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                        <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                        <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                        <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                        </svg>
                                        <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                        <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                        <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                        <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                        <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                        <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                        <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                        <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                        </svg>
                                    </span>
                                </span>
                            </a>
                        </div>
                    </div>
                    <div class="xb-project-stricky pb-115">
                        <div class="xb-project-item sticky-card">
                            <div class="xb-project-inner xb-project-inner--left">
                                <div class="xb-item--heading">
                                    <h2 class="xb-item--title"><a href="project-details.html">Business development planning.</a></h2>
                                    <p class="xb-item--content clr-white">Business development planning involves creating strategic approaches to identify growth opportunities, build strong client relationships, and improve market.</p>
                                </div>
                                <div class="xb-item--btn arrow_hover_effect">
                                    <span class="xb-item--text">View the case study</span>
                                    <a class="xb-item--arrow" href="project.html">
                                        <div class="xb-arrow">
                                            <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="6.25366" y="20.2168" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2168)" fill="white" />
                                            <rect x="9.29785" y="6.87256" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87256)" fill="white" />
                                            <rect x="13.1558" y="7.19092" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19092)" fill="white" />
                                            <rect x="17.0139" y="7.50928" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50928)" fill="white" />
                                            <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="white" />
                                            <rect x="20.2356" y="15.5444" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5444)" fill="white" />
                                            <rect x="19.9165" y="19.4023" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4023)" fill="white" />
                                            </svg>
                                            <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="6.25366" y="20.2168" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2168)" fill="white" />
                                            <rect x="9.29785" y="6.87256" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87256)" fill="white" />
                                            <rect x="13.1558" y="7.19092" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19092)" fill="white" />
                                            <rect x="17.0139" y="7.50928" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50928)" fill="white" />
                                            <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="white" />
                                            <rect x="20.2356" y="15.5444" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5444)" fill="white" />
                                            <rect x="19.9165" y="19.4023" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4023)" fill="white" />
                                            </svg>
                                        </div>
                                    </a>
                                    <a class="xb-overlay" href="project-details.html"></a>
                                </div>
                            </div>
                            <div class="xb-project-inner xb-project-inner--middle">
                                <div class="xb-item--inner">
                                    <ul class="xb-item--list list-unstyled">
                                        <li><span>Client:</span></li>
                                        <li>ic solutions</li>
                                    </ul>
                                    <ul class="xb-item--list list-unstyled">
                                        <li><span>Services:</span></li>
                                        <li>Business strategy</li>
                                        <li>Market planning</li>
                                        <li>Sales enablement</li>
                                    </ul>
                                </div>
                                <div class="xb-item--bottom">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/project/logo01.png" alt="project logo">
                                </div>
                            </div>
                            <div class="xb-project-inner xb-project-inner--right hover-effect-img">
                                <a href="project-details.html">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/project/img01.jpg" alt="image">
                                </a>
                            </div>
                        </div>
                        <div class="xb-project-item sticky-card">
                            <div class="xb-project-inner xb-project-inner--left">
                                <div class="xb-item--heading">
                                    <h2 class="xb-item--title"><a href="project-details.html">Customer experience enhancement..</a></h2>
                                    <p class="xb-item--content clr-white">Customer experience enhancement focuses on improving every interaction your customers have with your business, ensuring satisfaction, loyalty.</p>
                                </div>
                                <div class="xb-item--btn arrow_hover_effect">
                                    <span class="xb-item--text">View the case study</span>
                                    <a class="xb-item--arrow" href="project.html">
                                        <div class="xb-arrow">
                                            <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="6.25366" y="20.2168" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2168)" fill="white" />
                                            <rect x="9.29785" y="6.87256" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87256)" fill="white" />
                                            <rect x="13.1558" y="7.19092" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19092)" fill="white" />
                                            <rect x="17.0139" y="7.50928" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50928)" fill="white" />
                                            <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="white" />
                                            <rect x="20.2356" y="15.5444" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5444)" fill="white" />
                                            <rect x="19.9165" y="19.4023" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4023)" fill="white" />
                                            </svg>
                                            <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="6.25366" y="20.2168" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2168)" fill="white" />
                                            <rect x="9.29785" y="6.87256" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87256)" fill="white" />
                                            <rect x="13.1558" y="7.19092" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19092)" fill="white" />
                                            <rect x="17.0139" y="7.50928" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50928)" fill="white" />
                                            <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="white" />
                                            <rect x="20.2356" y="15.5444" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5444)" fill="white" />
                                            <rect x="19.9165" y="19.4023" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4023)" fill="white" />
                                            </svg>
                                        </div>
                                    </a>
                                    <a class="xb-overlay" href="project-details.html"></a>
                                </div>
                            </div>
                            <div class="xb-project-inner xb-project-inner--middle">
                                <div class="xb-item--inner">
                                    <ul class="xb-item--list list-unstyled">
                                        <li><span>Client:</span></li>
                                        <li>access</li>
                                    </ul>
                                    <ul class="xb-item--list list-unstyled">
                                        <li><span>Services:</span></li>
                                        <li>Customer segmentation</li>
                                        <li>Service design</li>
                                        <li>Performance analytics</li>
                                    </ul>
                                </div>
                                <div class="xb-item--bottom">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/project/logo02.png" alt="project logo">
                                </div>
                            </div>
                            <div class="xb-project-inner xb-project-inner--right hover-effect-img">
                                <a href="project-details.html">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/project/img02.jpg" alt="image">
                                </a>
                            </div>
                        </div>
                        <div class="xb-project-item sticky-card">
                            <div class="xb-project-inner xb-project-inner--left">
                                <div class="xb-item--heading">
                                    <h2 class="xb-item--title"><a href="project-details.html">Market & competitor analysis..</a></h2>
                                    <p class="xb-item--content clr-white">We deliver actionable insights into market trends and competitor strategies, helping businesses uncover new opportunities for growth and success.</p>
                                </div>
                                <div class="xb-item--btn arrow_hover_effect">
                                    <span class="xb-item--text">View the case study</span>
                                    <a class="xb-item--arrow" href="project.html">
                                        <div class="xb-arrow">
                                            <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="6.25366" y="20.2168" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2168)" fill="white" />
                                            <rect x="9.29785" y="6.87256" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87256)" fill="white" />
                                            <rect x="13.1558" y="7.19092" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19092)" fill="white" />
                                            <rect x="17.0139" y="7.50928" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50928)" fill="white" />
                                            <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="white" />
                                            <rect x="20.2356" y="15.5444" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5444)" fill="white" />
                                            <rect x="19.9165" y="19.4023" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4023)" fill="white" />
                                            </svg>
                                            <svg width="30" height="29" viewBox="0 0 30 29" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="6.25366" y="20.2168" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2168)" fill="white" />
                                            <rect x="9.29785" y="6.87256" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87256)" fill="white" />
                                            <rect x="13.1558" y="7.19092" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19092)" fill="white" />
                                            <rect x="17.0139" y="7.50928" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50928)" fill="white" />
                                            <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="white" />
                                            <rect x="20.2356" y="15.5444" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5444)" fill="white" />
                                            <rect x="19.9165" y="19.4023" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4023)" fill="white" />
                                            </svg>
                                        </div>
                                    </a>
                                    <a class="xb-overlay" href="project-details.html"></a>
                                </div>
                            </div>
                            <div class="xb-project-inner xb-project-inner--middle">
                                <div class="xb-item--inner">
                                    <ul class="xb-item--list list-unstyled">
                                        <li><span>Client:</span></li>
                                        <li>busha</li>
                                    </ul>
                                    <ul class="xb-item--list list-unstyled">
                                        <li><span>Services:</span></li>
                                        <li>Benchmarking</li>
                                        <li>Trend forecasting</li>
                                        <li>Customer insights</li>
                                    </ul>
                                </div>
                                <div class="xb-item--bottom">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/project/logo03.png" alt="project logo">
                                </div>
                            </div>
                            <div class="xb-project-inner xb-project-inner--right hover-effect-img">
                                <a href="project-details.html">
                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/project/img03.jpg" alt="image">
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- project end -->

        <!-- team start -->
        <section class="team pb-150">
            <div class="container-fluid p-0">
                <div class="xb-team-wrapper mlr-70">
                    <div class="xb-team-top sec-title-wrap ul_li_between mb-55">
                        <div class="sec-title ul_li">
                            <span class="sub-title">Our team</span>
                            <div class="xb-holder">
                                <h2 class="title xb-text-reveal">Meet the team behind your project</h2>
                            </div>
                        </div>
                        <p class="content">Meet the team behind your project — experienced professionals delivering smart, customized solutions to help your business reach its goals and bring your vision to life.</p>
                    </div>
                   <div class="row">

    <!-- LEFT COLUMN -->
    <div class="col-xl-4 col-md-6">
        <div class="xb-team-inner_wrap left">

            <!-- Team 1 -->
            <div class="xb-team-item wow fadeInUp" data-wow-delay="0ms" data-wow-duration="600ms">
                
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/team/img01.jpg" 
                     alt="Sebastian Patel" 
                     class="team-bg-img">

                <div class="xb-item--holder ul_li_between">
                    <div class="xb-item--avatar">
                        <h2 class="xb-item--name">Sebastian Patel</h2>
                        <span class="xb-item--desig clr-white">Managing Director</span>
                    </div>
                    <a class="xb-item--link" href="#!">
                        <i class="fa-brands fa-linkedin-in"></i>
                    </a>
                </div>

                <div class="glassy-shape">
                    <!-- KEEP YOUR SVG HERE (unchanged) -->
                </div>
            </div>

            <!-- Team 2 -->
            <div class="xb-team-item wow fadeInUp" data-wow-delay="150ms" data-wow-duration="600ms">
                
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/team/img02.jpg" 
                     alt="Eliana Rose" 
                     class="team-bg-img">

                <div class="xb-item--holder ul_li_between">
                    <div class="xb-item--avatar">
                        <h2 class="xb-item--name">Eliana Rose</h2>
                        <span class="xb-item--desig clr-white">Financial Advisor</span>
                    </div>
                    <a class="xb-item--link" href="#!">
                        <i class="fa-brands fa-linkedin-in"></i>
                    </a>
                </div>

                <div class="glassy-shape">
                    <!-- KEEP YOUR SVG HERE -->
                </div>
            </div>

        </div>
    </div>


    <!-- MIDDLE COLUMN -->
    <div class="col-xl-4 col-lg-6 order-last order-xl-0">
        <div class="xb-team-inner_wrap middle">

            <div class="xb-team-item xb-team-item--middle wow fadeInUp" data-wow-delay="0ms" data-wow-duration="600ms">

                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/team/img03.jpg" 
                     alt="Lennox Gabriel" 
                     class="team-bg-img">

                <div class="xb-item--holder ul_li_between">
                    <div class="xb-item--avatar">
                        <h2 class="xb-item--name">Lennox Gabriel</h2>
                        <span class="xb-item--desig clr-white">Chief Executive Officer (CEO)</span>
                    </div>
                    <a class="xb-item--link" href="#!">
                        <i class="fa-brands fa-linkedin-in"></i>
                    </a>
                </div>

                <div class="glassy-shape">
                    <!-- KEEP YOUR SVG HERE -->
                </div>

            </div>

        </div>
    </div>


    <!-- RIGHT COLUMN -->
    <div class="col-xl-4 col-md-6">
        <div class="xb-team-inner_wrap right">

            <!-- Team 4 -->
            <div class="xb-team-item wow fadeInUp" data-wow-delay="0ms" data-wow-duration="600ms">

                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/team/img04.jpg" 
                     alt="Priya Ramirez" 
                     class="team-bg-img">

                <div class="xb-item--holder ul_li_between">
                    <div class="xb-item--avatar">
                        <h2 class="xb-item--name">Priya Ramirez</h2>
                        <span class="xb-item--desig clr-white">Business Consultant</span>
                    </div>
                    <a class="xb-item--link" href="#!">
                        <i class="fa-brands fa-linkedin-in"></i>
                    </a>
                </div>

                <div class="glassy-shape">
                    <!-- KEEP YOUR SVG HERE -->
                </div>
            </div>

            <!-- Team 5 -->
            <div class="xb-team-item wow fadeInUp" data-wow-delay="150ms" data-wow-duration="600ms">

                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/team/img05.jpg" 
                     alt="Grayson Cole" 
                     class="team-bg-img">

                <div class="xb-item--holder ul_li_between">
                    <div class="xb-item--avatar">
                        <h2 class="xb-item--name">Grayson Cole</h2>
                        <span class="xb-item--desig clr-white">Marketing Strategist</span>
                    </div>
                    <a class="xb-item--link" href="#!">
                        <i class="fa-brands fa-linkedin-in"></i>
                    </a>
                </div>

                <div class="glassy-shape">
                    <!-- KEEP YOUR SVG HERE -->
                </div>
            </div>

        </div>
    </div>

</div>

                    <div class="xb-team-btn text-center mt-50">
                        <a class="thm-btn arrow_hover_effect" href="team.html">
                            <span class="btn_label" data-text="View all team members">View all team members</span>
                            <span class="xb-icon">
                                <span class="xb-arrow">
                                    <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                    <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                    <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                    <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                    <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                    <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                    <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                    <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                    </svg>
                                    <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                    <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                    <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                    <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                    <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                    <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                    <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                    <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                    </svg>
                                </span>
                            </span>
                        </a>
                    </div>
                </div>
            </div>
        </section>
        <!-- team end -->

        <!-- contact start -->
        <section class="contact pos-rel pt-150
         pb-150" data-bg-color="#f8f5ff">
            <div class="container-fluid p-0">
                <div class="xb-contact-wrapper mlr-70">
                    <div class="row mt-none-50">
                        <div class="col-xl-7 col-lg-12  mt-50">
                            <div class="xb-contact-content-wrap">
                                <div class="sec-title contact-sec-title ul_li mb-45">
                                    <span class="sub-title">let’s start</span>
                                    <div class="xb-holder">
                                        <h2 class="title xb-text-reveal">Every successful strategy starts with a chat</h2>
                                    </div>
                                </div>
                                <div class="xb-contact-content">
                                    <div class="xb-contact-ser_list">
                                        <p class="text">What you gain by connecting with us</p>
                                        <ul class="list list-unstyled">
                                            <li>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/check.svg" alt="icon">
                                                Tailored Business Orientation.
                                            </li>
                                            <li>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/check.svg" alt="icon">
                                                In-Depth Problem Diagnosis.
                                            </li>
                                            <li>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/check.svg" alt="icon">
                                                Free Initial Consultation.
                                            </li>
                                            <li>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/check.svg" alt="icon">
                                                Certified & Experienced Consultants.
                                            </li>
                                            <li>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/check.svg" alt="icon">
                                                Strategic Business Analysis.
                                            </li>
                                            <li>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/check.svg" alt="icon">
                                                24/7 Expert Support.
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="xb-contact-method ul_li">
                                        <ul class="list-unstyled">
                                            <li class="text">Our office location</li>
                                            <li>
                                                <span>
                                                    <svg width="18" height="20" viewBox="0 0 18 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M16.9018 6.74616C15.9393 2.51116 12.2451 0.604492 9.00009 0.604492C9.00009 0.604492 9.00009 0.604492 8.99092 0.604492C5.75509 0.604492 2.05175 2.50199 1.08925 6.73699C0.016754 11.467 2.91342 15.4728 5.53509 17.9937C6.50675 18.9287 7.75342 19.3962 9.00009 19.3962C10.2468 19.3962 11.4934 18.9287 12.4559 17.9937C15.0776 15.4728 17.9743 11.4762 16.9018 6.74616ZM9.00009 11.3387C7.40509 11.3387 6.11259 10.0462 6.11259 8.45116C6.11259 6.85616 7.40509 5.56366 9.00009 5.56366C10.5951 5.56366 11.8876 6.85616 11.8876 8.45116C11.8876 10.0462 10.5951 11.3387 9.00009 11.3387Z" fill="#8348FF" />
                                                    </svg>
                                                </span>
                                                845 Market St #203 San <br> Francisco, California (CA)
                                            </li>
                                        </ul>
                                        <ul class="list-unstyled">
                                            <li class="text">Hurry up! Contact with us</li>
                                            <li>
                                                <span>
                                                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M17.8749 7.33333C19.1406 7.33333 20.1666 6.30732 20.1666 5.04167C20.1666 3.77601 19.1406 2.75 17.8749 2.75C16.6093 2.75 15.5833 3.77601 15.5833 5.04167C15.5833 6.30732 16.6093 7.33333 17.8749 7.33333Z" fill="#8348FF" />
                                                    <path d="M17.8749 7.33333C19.1406 7.33333 20.1666 6.30732 20.1666 5.04167C20.1666 3.77601 19.1406 2.75 17.8749 2.75C16.6093 2.75 15.5833 3.77601 15.5833 5.04167C15.5833 6.30732 16.6093 7.33333 17.8749 7.33333Z" fill="#8348FF" />
                                                    <path d="M18.9932 8.53384C18.3516 8.73551 17.6458 8.77217 16.9124 8.58884C15.6841 8.26801 14.6849 7.28717 14.3458 6.05884C14.1808 5.46301 14.1716 4.87634 14.2724 4.34467C14.3916 3.75801 13.9791 3.20801 13.3924 3.20801H6.41658C3.66659 3.20801 1.83325 4.58301 1.83325 7.79134V14.208C1.83325 17.4163 3.66659 18.7913 6.41658 18.7913H15.5833C18.3333 18.7913 20.1666 17.4163 20.1666 14.208V9.40468C20.1666 8.79967 19.5799 8.34134 18.9932 8.53384ZM14.2266 10.2205L13.1449 11.0822C12.5399 11.568 11.7699 11.8063 10.9999 11.8063C10.2299 11.8063 9.45075 11.568 8.85492 11.0822L5.98575 8.79051C5.69242 8.55217 5.64658 8.11217 5.87575 7.81884C6.11408 7.52551 6.54492 7.47051 6.83825 7.70884L9.70742 10.0005C10.4041 10.5597 11.5866 10.5597 12.2833 10.0005L13.3649 9.13884C13.6583 8.90051 14.0983 8.94634 14.3274 9.24884C14.5658 9.54217 14.5199 9.98217 14.2266 10.2205Z" fill="#8348FF" />
                                                    </svg>
                                                </span>
                                                <a href="mailto:bizoxdomain@gmail.com">bizoxdomain@gmail.com</a>
                                            </li>
                                            <li>
                                                <span>
                                                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M16.1516 9.85462C15.7574 9.85462 15.4458 9.53379 15.4458 9.14879C15.4458 8.80962 15.1066 8.10379 14.5383 7.48962C13.9791 6.89379 13.3649 6.54546 12.8516 6.54546C12.4574 6.54546 12.1458 6.22462 12.1458 5.83962C12.1458 5.45462 12.4666 5.13379 12.8516 5.13379C13.7683 5.13379 14.7308 5.62879 15.5741 6.51796C16.3624 7.35212 16.8666 8.38796 16.8666 9.13962C16.8666 9.53379 16.5458 9.85462 16.1516 9.85462Z" fill="#8348FF" />
                                                    <path d="M19.4609 9.85384C19.0667 9.85384 18.755 9.53301 18.755 9.14801C18.755 5.89384 16.1059 3.25384 12.8609 3.25384C12.4667 3.25384 12.155 2.93301 12.155 2.54801C12.155 2.16301 12.4667 1.83301 12.8517 1.83301C16.885 1.83301 20.1667 5.11467 20.1667 9.14801C20.1667 9.53301 19.8459 9.85384 19.4609 9.85384Z" fill="#8348FF" />
                                                    <path d="M10.1291 13.7038L8.43325 15.3997C8.07575 15.7572 7.50742 15.7572 7.14075 15.4088C7.03992 15.308 6.93909 15.2163 6.83825 15.1155C5.89409 14.1622 5.04159 13.163 4.28075 12.118C3.52909 11.073 2.92409 10.028 2.48409 8.99218C2.05325 7.94718 1.83325 6.94801 1.83325 5.99467C1.83325 5.37134 1.94325 4.77551 2.16325 4.22551C2.38325 3.66634 2.73159 3.15301 3.21742 2.69467C3.80409 2.11717 4.44575 1.83301 5.12409 1.83301C5.38075 1.83301 5.63742 1.88801 5.86659 1.99801C6.10492 2.10801 6.31575 2.27301 6.48075 2.51134L8.60742 5.50884C8.77242 5.73801 8.89158 5.94884 8.97408 6.15051C9.05658 6.34301 9.10242 6.53551 9.10242 6.70967C9.10242 6.92967 9.03825 7.14967 8.90992 7.36051C8.79075 7.57134 8.61658 7.79134 8.39658 8.01134L7.69992 8.73551C7.59908 8.83634 7.55325 8.95551 7.55325 9.10217C7.55325 9.17551 7.56242 9.23967 7.58075 9.31301C7.60825 9.38634 7.63575 9.44134 7.65409 9.49634C7.81909 9.79884 8.10325 10.193 8.50658 10.6697C8.91908 11.1463 9.35908 11.6322 9.83575 12.118C9.92742 12.2097 10.0283 12.3013 10.1199 12.393C10.4866 12.7505 10.4958 13.3372 10.1291 13.7038Z" fill="#8348FF" />
                                                    <path d="M20.1392 16.8026C20.1392 17.0593 20.0934 17.3251 20.0017 17.5818C19.9742 17.6551 19.9467 17.7285 19.91 17.8018C19.7542 18.1318 19.5525 18.4435 19.2867 18.7368C18.8375 19.2318 18.3425 19.5893 17.7834 19.8185C17.7742 19.8185 17.765 19.8276 17.7559 19.8276C17.215 20.0476 16.6284 20.1668 15.9959 20.1668C15.0609 20.1668 14.0617 19.9468 13.0075 19.4976C11.9534 19.0485 10.8992 18.4435 9.85422 17.6826C9.49672 17.4168 9.13922 17.1509 8.80005 16.8668L11.7975 13.8693C12.0542 14.0618 12.2834 14.2085 12.4759 14.3093C12.5217 14.3276 12.5767 14.3551 12.6409 14.3826C12.7142 14.4101 12.7875 14.4193 12.87 14.4193C13.0259 14.4193 13.145 14.3643 13.2459 14.2635L13.9425 13.576C14.1717 13.3468 14.3917 13.1726 14.6025 13.0626C14.8134 12.9343 15.0242 12.8701 15.2534 12.8701C15.4275 12.8701 15.6109 12.9068 15.8125 12.9893C16.0142 13.0718 16.225 13.191 16.4542 13.3468L19.4884 15.501C19.7267 15.666 19.8917 15.8584 19.9925 16.0876C20.0842 16.3168 20.1392 16.546 20.1392 16.8026Z" fill="#8348FF" />
                                                    </svg>
                                                </span>
                                                <a href="tel:+17035555678">+1 703-555-5678</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-5 col-lg-12  mt-50">
                            <div class="xb-contact-form wow fadeInRight" data-wow-delay="0ms" data-wow-duration="600ms">
                                <div class="form-heading mb-45">
                                    <span class="sub-title"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/cap-icon.svg" alt="iocn"> Let's connect!</span>
                                    <h3 class="title">Ready to collaborate with us?</h3>
                                </div>
                                <form action="#!" class="xb-contact-input-form">
                                    <div class="row mt-none-20">
                                        <div class="col-lg-6 col-md-6 mt-20">
                                            <div class="xb-input-field">
                                                <input id="author-name" type="text" required>
                                                <label for="author-name">Your Name*</label>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/user-white-icon.svg" alt="icon">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 mt-20">
                                            <div class="xb-input-field">
                                                <input id="author-email" type="email" required>
                                                <label for="author-email">Email Address*</label>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/mail-white-icon.svg" alt="icon">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 mt-20">
                                            <div class="xb-input-field">
                                                <input id="author-phone" type="text" required>
                                                <label for="author-phone">Contact No*</label>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/call-white-icon.svg" alt="icon">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 mt-20">
                                            <div class="xb-input-field xb-select-field">
                                                <select class="nice-select">
                                                    <option value="1">What are you needs?</option>
                                                    <option value="2">AI - marketing</option>
                                                    <option value="3">AI consulting</option>
                                                    <option value="4">AI chatbot virtual</option>
                                                </select>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/book-white-icon.svg" alt="icon">
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12 mt-20">
                                            <div class="xb-input-field xb-massage-field">
                                                <textarea id="massage" required></textarea>
                                                <label for="massage">How can we help you?</label>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/sms-white-icon.svg" alt="icon">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-submit-btn mt-25">
                                        <button type="submit" class="form-btn arrow_hover_effect">
                                            Send request
                                            <span class="xb-arrow">
                                                <svg width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="4.57886" y="17.3848" width="18.552" height="2.35581" transform="rotate(-40.2798 4.57886 17.3848)" fill="white" />
                                                <rect x="7.19873" y="5.90186" width="2.35581" height="2.35581" transform="rotate(-40.2798 7.19873 5.90186)" fill="white" />
                                                <rect x="10.5188" y="6.17529" width="2.35581" height="2.35581" transform="rotate(-40.2798 10.5188 6.17529)" fill="white" />
                                                <rect x="13.8391" y="6.44971" width="2.35581" height="2.35581" transform="rotate(-40.2798 13.8391 6.44971)" fill="white" />
                                                <rect x="16.8853" y="10.0444" width="2.35581" height="2.35581" transform="rotate(-40.2798 16.8853 10.0444)" fill="white" />
                                                <rect x="16.6118" y="13.3647" width="2.35581" height="2.35581" transform="rotate(-40.2798 16.6118 13.3647)" fill="white" />
                                                <rect x="16.3372" y="16.6841" width="2.35581" height="2.35581" transform="rotate(-40.2798 16.3372 16.6841)" fill="white" />
                                                </svg>
                                                <svg width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <rect x="4.57886" y="17.3848" width="18.552" height="2.35581" transform="rotate(-40.2798 4.57886 17.3848)" fill="white" />
                                                <rect x="7.19873" y="5.90186" width="2.35581" height="2.35581" transform="rotate(-40.2798 7.19873 5.90186)" fill="white" />
                                                <rect x="10.5188" y="6.17529" width="2.35581" height="2.35581" transform="rotate(-40.2798 10.5188 6.17529)" fill="white" />
                                                <rect x="13.8391" y="6.44971" width="2.35581" height="2.35581" transform="rotate(-40.2798 13.8391 6.44971)" fill="white" />
                                                <rect x="16.8853" y="10.0444" width="2.35581" height="2.35581" transform="rotate(-40.2798 16.8853 10.0444)" fill="white" />
                                                <rect x="16.6118" y="13.3647" width="2.35581" height="2.35581" transform="rotate(-40.2798 16.6118 13.3647)" fill="white" />
                                                <rect x="16.3372" y="16.6841" width="2.35581" height="2.35581" transform="rotate(-40.2798 16.3372 16.6841)" fill="white" />
                                                </svg>
                                            </span>
                                        </button>
                                    </div>
                                </form>
                                <div class="xb-shape"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/contact/vector.png" alt="shape"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="xb-contact-shape">
                    <div class="img">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/shape/earth-shape02.png" alt="shape">
                    </div>
                </div>
            </div>
        </section>
        <!-- contact end -->

        <!-- testimonial start -->
        <section class="testimonial bg-linear pt-140 pb-150">
            <div class="container-fluid p-0">
                <div class="xb-testimonial-wrapper mlr-70">
                    <div class="xb-testimonial-top sec-title-wrap ul_li_between mb-65">
                        <div class="sec-title ul_li align-items-center">
                            <span class="sub-title clr-white">testimonial</span>
                            <h2 class="title xb-text-reveal clr-white">Happy clients observation</h2>
                        </div>
                        <div class="xb-testimonial-review">
                            <ul class="xb-rating list-unstyled ul_li">
                                <li class="text">Reviewed on</li>
                                <li><i class="fa-solid fa-star-sharp"></i></li>
                                <li><i class="fa-solid fa-star-sharp"></i></li>
                                <li><i class="fa-solid fa-star-sharp"></i></li>
                                <li><i class="fa-solid fa-star-sharp"></i></li>
                                <li><i class="fa-solid fa-star-sharp"></i></li>
                            </ul>
                            <ul class="xb-review list-unstyled ul_li">
                                <li><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/google.png" alt="logo"></li>
                                <li class="text"><span class="">4.9/5 Reviews</span></li>
                            </ul>
                        </div>
                    </div>
                    <div class="xb-testimonial-inner">
                        <div class="row g-0 mt-none-30">       
                            <div class="col-xl-7 col-md-12 mt-30">
                                <div class="xb-testimonial-slider swiper-container">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <div class="xb-testimonial-item">
                                                <div class="xb-item--img">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img01.jpg" alt="image">
                                                    <span class="xb-item--icon">
                                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                    </span>
                                                </div>
                                                <div class="xb-item--inner_content">
                                                    <h2 class="xb-item--title">"Partnering in our growth"</h2>
                                                    <p class="xb-item--content">
                                                        "Working with Bizox was truly transformative. Their consultants brought fresh perspectives and actionable insights that helped us scale our business smarter. We now have a sustainable growth strategy already delivering tangible results."
                                                    </p>
                                                    <div class="xb-item--holder ul_li_between">
                                                        <div class="xb-item--author">
                                                            <h4 class="xb-item--name">Joseph Wilson</h4>
                                                            <p class="xb-item--desig"> CEO, Huobi Solutions</p>
                                                        </div>
                                                        <div class="xb-item--logo">
                                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/tes-logo01.png" alt="logo">
                                                        </div>
                                                    </div>
                                                    <div class="xb-item--quote"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-big-icon.svg" alt="icon"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="xb-testimonial-item">
                                                <div class="xb-item--img">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img02.jpg" alt="image">
                                                    <span class="xb-item--icon">
                                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                    </span>
                                                </div>
                                                <div class="xb-item--inner_content">
                                                    <h2 class="xb-item--title">"Turning plans into results"</h2>
                                                    <p class="xb-item--content">
                                                        "Bizox helped us identify inefficiencies we didn’t even realize were quietly holding us back. just a month, we saw significantly improved workflow, reduced costs, and stronger team alignment. Their strategic clarity and actionable insights truly made an impact."
                                                    </p>
                                                    <div class="xb-item--holder ul_li_between">
                                                        <div class="xb-item--author">
                                                            <h4 class="xb-item--name">Amelia Thomas</h4>
                                                            <p class="xb-item--desig">Managing Director, alphax</p>
                                                        </div>
                                                        <div class="xb-item--logo">
                                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/tes-logo02.png" alt="logo">
                                                        </div>
                                                    </div>
                                                    <div class="xb-item--quote"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-big-icon.svg" alt="icon"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="xb-testimonial-item">
                                                <div class="xb-item--img">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img03.jpg" alt="image">
                                                    <span class="xb-item--icon">
                                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                    </span>
                                                </div>
                                                <div class="xb-item--inner_content">
                                                    <h2 class="xb-item--title">"Strategic guidance that delivers"</h2>
                                                    <p class="xb-item--content">
                                                        The team’s insights helped us restructure our operations for better performance and cost savings. Their strategic approach gave us a clear roadmap, and we saw results within weeks. I highly recommend them for any business looking to grow smart and sustainably.
                                                    </p>
                                                    <div class="xb-item--holder ul_li_between">
                                                        <div class="xb-item--author">
                                                            <h4 class="xb-item--name">Maverick Phoenix</h4>
                                                            <p class="xb-item--desig">Operations Director, Provicw</p>
                                                        </div>
                                                        <div class="xb-item--logo">
                                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/tes-logo03.png" alt="logo">
                                                        </div>
                                                    </div>
                                                    <div class="xb-item--quote"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-big-icon.svg" alt="icon"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="xb-testimonial-item">
                                                <div class="xb-item--img">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img04.jpg" alt="image">
                                                    <span class="xb-item--icon">
                                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                    </span>
                                                </div>
                                                <div class="xb-item--inner_content">
                                                    <h2 class="xb-item--title">"Practical Insights, Real Change"</h2>
                                                    <p class="xb-item--content">
                                                        "Bizox’s team didn’t just give advice — they gave us a clear roadmap. Their strategic guidance helped us streamline operations, boost efficiency, and enhance overall profitability. They’ve become our go-to partner for ongoing business improvement."
                                                    </p>
                                                    <div class="xb-item--holder ul_li_between">
                                                        <div class="xb-item--author">
                                                            <h4 class="xb-item--name">Maria Kowalska</h4>
                                                            <p class="xb-item--desig">Operations Head, Jotform</p>
                                                        </div>
                                                        <div class="xb-item--logo">
                                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/tes-logo04.png" alt="logo">
                                                        </div>
                                                    </div>
                                                    <div class="xb-item--quote"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-big-icon.svg" alt="icon"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="xb-testimonial-item">
                                                <div class="xb-item--img">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img05.jpg" alt="image">
                                                    <span class="xb-item--icon">
                                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                    </span>
                                                </div>
                                                <div class="xb-item--inner_content">
                                                    <h2 class="xb-item--title">"Leadership Through Strategy"</h2>
                                                    <p class="xb-item--content">
                                                        "The Bizox team expertly guided our leadership through a challenging restructuring phase with clarity, focus, and complete confidence. Their unique blend of data-driven analysis and human insight truly set them apart from other consulting firms."
                                                    </p>
                                                    <div class="xb-item--holder ul_li_between">
                                                        <div class="xb-item--author">
                                                            <h4 class="xb-item--name">Charles Moore</h4>
                                                            <p class="xb-item--desig">COO, Busha Global</p>
                                                        </div>
                                                        <div class="xb-item--logo">
                                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/tes-logo05.png" alt="logo">
                                                        </div>
                                                    </div>
                                                    <div class="xb-item--quote"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-big-icon.svg" alt="icon"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="xb-testimonial-item">
                                                <div class="xb-item--img">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img06.jpg" alt="image">
                                                    <span class="xb-item--icon">
                                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                    </span>
                                                </div>
                                                <div class="xb-item--inner_content">
                                                    <h2 class="xb-item--title">"Smart strategy, tangible results"</h2>
                                                    <p class="xb-item--content">
                                                        "The Bizox team expertly guided our leadership through a challenging restructuring phase with clarity, focus, and complete confidence. Their unique blend of data-driven analysis, practical solutions, and human insight truly set them apart from other consulting."
                                                    </p>
                                                    <div class="xb-item--holder ul_li_between">
                                                        <div class="xb-item--author">
                                                            <h4 class="xb-item--name">Michael Johnson</h4>
                                                            <p class="xb-item--desig">Founder, Gate.io Consulting</p>
                                                        </div>
                                                        <div class="xb-item--logo">
                                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/tes-logo06.png" alt="logo">
                                                        </div>
                                                    </div>
                                                    <div class="xb-item--quote"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-big-icon.svg" alt="icon"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-md-10 mt-30">
                                <div class="xb-testimonial-author swiper-container">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <div class="xb-tes-author">
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img07.jpg" alt="image">
                                                <span class="xb-icon">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                </span>
                                                <div class="arrow-active">
                                                    <svg width="52" height="46" viewBox="0 0 52 46" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <rect width="51.4432" height="6.53247" transform="matrix(-1 0 0 1 51.4431 19.5967)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3137 0)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7808 6.53027)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2478 13.0635)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2471 26.1279)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7793 32.6621)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3123 39.1934)" fill="#191B21" />
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="xb-tes-author">
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img08.jpg" alt="image">
                                                <span class="xb-icon">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                </span>
                                                <div class="arrow-active">
                                                    <svg width="52" height="46" viewBox="0 0 52 46" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <rect width="51.4432" height="6.53247" transform="matrix(-1 0 0 1 51.4431 19.5967)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3137 0)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7808 6.53027)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2478 13.0635)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2471 26.1279)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7793 32.6621)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3123 39.1934)" fill="#191B21" />
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="xb-tes-author">
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img09.jpg" alt="image">
                                                <span class="xb-icon">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                </span>
                                                <div class="arrow-active">
                                                    <svg width="52" height="46" viewBox="0 0 52 46" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <rect width="51.4432" height="6.53247" transform="matrix(-1 0 0 1 51.4431 19.5967)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3137 0)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7808 6.53027)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2478 13.0635)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2471 26.1279)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7793 32.6621)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3123 39.1934)" fill="#191B21" />
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="xb-tes-author">
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img10.jpg" alt="image">
                                                <span class="xb-icon">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                </span>
                                                <div class="arrow-active">
                                                    <svg width="52" height="46" viewBox="0 0 52 46" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <rect width="51.4432" height="6.53247" transform="matrix(-1 0 0 1 51.4431 19.5967)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3137 0)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7808 6.53027)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2478 13.0635)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2471 26.1279)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7793 32.6621)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3123 39.1934)" fill="#191B21" />
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="xb-tes-author">
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img11.jpg" alt="image">
                                                <span class="xb-icon">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                </span>
                                                <div class="arrow-active">
                                                    <svg width="52" height="46" viewBox="0 0 52 46" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <rect width="51.4432" height="6.53247" transform="matrix(-1 0 0 1 51.4431 19.5967)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3137 0)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7808 6.53027)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2478 13.0635)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2471 26.1279)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7793 32.6621)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3123 39.1934)" fill="#191B21" />
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="xb-tes-author">
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/testimonial/img12.jpg" alt="image">
                                                <span class="xb-icon">
                                                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/icon/quote-icon.svg" alt="icon">
                                                </span>
                                                <div class="arrow-active">
                                                    <svg width="52" height="46" viewBox="0 0 52 46" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <rect width="51.4432" height="6.53247" transform="matrix(-1 0 0 1 51.4431 19.5967)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3137 0)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7808 6.53027)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2478 13.0635)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 12.2471 26.1279)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 18.7793 32.6621)" fill="#191B21" />
                                                    <rect width="6.53247" height="6.53247" transform="matrix(-1 0 0 1 25.3123 39.1934)" fill="#191B21" />
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-1 col-md-2 order-xl-first mt-30">
                                <div class="xb-testimonial-arrow">
                                    <div class="swiper-button-next tes-arrow">
                                        <span>
                                            <svg width="31" height="28" viewBox="0 0 31 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect x="-0.000244141" y="11.6406" width="30.557" height="3.88025" fill="#191B21" />
                                            <rect x="15.5205" width="3.88025" height="3.88025" fill="#191B21" />
                                            <rect x="19.4011" y="3.87988" width="3.88025" height="3.88025" fill="#191B21" />
                                            <rect x="23.2815" y="7.75977" width="3.88025" height="3.88025" fill="#191B21" />
                                            <rect x="23.282" y="15.5195" width="3.88025" height="3.88025" fill="#191B21" />
                                            <rect x="19.4019" y="19.4014" width="3.88025" height="3.88025" fill="#191B21" />
                                            <rect x="15.5212" y="23.2812" width="3.88025" height="3.88025" fill="#191B21" />
                                            </svg>
                                        </span>
                                    </div>
                                    <div class="swiper-button-prev tes-arrow">
                                        <span>
                                            <svg width="31" height="28" viewBox="0 0 31 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect width="30.557" height="3.88025" transform="matrix(-1 0 0 1 30.5569 11.6406)" fill="#191B21" />
                                            <rect width="3.88025" height="3.88025" transform="matrix(-1 0 0 1 15.0361 0)" fill="#191B21" />
                                            <rect width="3.88025" height="3.88025" transform="matrix(-1 0 0 1 11.1555 3.87988)" fill="#191B21" />
                                            <rect width="3.88025" height="3.88025" transform="matrix(-1 0 0 1 7.27515 7.75977)" fill="#191B21" />
                                            <rect width="3.88025" height="3.88025" transform="matrix(-1 0 0 1 7.27466 15.5195)" fill="#191B21" />
                                            <rect width="3.88025" height="3.88025" transform="matrix(-1 0 0 1 11.1548 19.4014)" fill="#191B21" />
                                            <rect width="3.88025" height="3.88025" transform="matrix(-1 0 0 1 15.0354 23.2812)" fill="#191B21" />
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- testimonial end -->

        <!-- blog start -->
        <section class="blog pt-140 pb-150">
            <div class="container-fluid p-0">
                <div class="xb-blog-wrapper mlr-70">
                    <div class="xb-service-top sec-title-wrap ul_li_between mb-65">
                        <div class="sec-title ul_li align-items-center">
                            <span class="sub-title">Our Blog</span>
                            <h2 class="title xb-text-reveal">Featured blog and insights</h2>
                        </div>
                        <div class="xb-blog-btn">
                            <a class="thm-btn arrow_hover_effect" href="blog.html">
                                <span class="btn_label" data-text="View all blog">View all blog</span>
                                <span class="xb-icon">
                                    <span class="xb-arrow">
                                        <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                        <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                        <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                        <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                        <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                        <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                        <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                        <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                        </svg>
                                        <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                        <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                        <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                        <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                        <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                        <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                        <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                        <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                        </svg>
                                    </span>
                                </span>
                            </a>
                        </div>
                    </div>
                    <div class="row mt-none-30">
                        <div class="col-xl-6 col-lg-6 mt-30">
                            <div class="xb-blog-item xb-blog-big hover-effect-img wow fadeInUp" data-wow-delay="0ms" data-wow-duration="600ms">
                                <div class="xb-item--img">
                                    <a href="blog-details.html"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/blog/img01.jpg" alt="image"></a>
                                </div>
                                <div class="xb-item--holder">
                                    <ul class="xb-item--meta list-unstyled">
                                        <li>19 dec 2025</li>
                                        <li>business  tips</li>
                                    </ul>
                                    <h2 class="xb-item--title border-effect">
                                        <a href="blog-details.html">Building tomorrow’s business success.. </a>
                                    </h2>
                                    <p class="xb-item--content">Building tomorrow’s business success begins with smart strategies and insights today, helping you grow sustainably and confidently.</p>
                                    <div class="xb-item--btn mt-85">
                                        <a class="thm-btn arrow_hover_effect" href="blog-details.html">
                                            <span class="btn_label" data-text="Read more blog">Read more blog</span>
                                            <span class="xb-icon">
                                                <span class="xb-arrow">
                                                    <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                                    <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                    <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                                    <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                                    <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                                    <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                                    <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                                    <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                    </svg>
                                                    <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                                    <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                    <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                                    <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                                    <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                                    <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                                    <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                                    <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                    </svg>
                                                </span>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6 mt-30">
                            <div class="xb-blog-item hover-effect-img wow fadeInUp" data-wow-delay="100ms" data-wow-duration="600ms">
                                <div class="xb-item--inner">
                                    <div class="xb-item--holder">
                                        <ul class="xb-item--meta list-unstyled">
                                            <li>28 nov 2025</li>
                                            <li>business  tips</li>
                                        </ul>
                                        <h2 class="xb-item--title border-effect">
                                            <a href="blog-details.html">Empowering your business journey with deep insights..</a>
                                        </h2>
                                        <div class="xb-item--btn mt-120">
                                            <a class="thm-btn arrow_hover_effect" href="blog-details.html">
                                                <span class="btn_label" data-text="Read more blog">Read more blog</span>
                                                <span class="xb-icon">
                                                    <span class="xb-arrow">
                                                        <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                                        <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                        <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                                        <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                                        <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                                        <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                                        <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                                        <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                        </svg>
                                                        <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                                        <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                        <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                                        <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                                        <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                                        <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                                        <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                                        <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                        </svg>
                                                    </span>
                                                </span>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="xb-item--img">
                                        <a href="blog-details.html"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/blog/img02.jpg" alt="image"></a>
                                    </div>
                                </div>
                            </div>
                            <div class="xb-blog-item hover-effect-img wow fadeInUp" data-wow-delay="200ms" data-wow-duration="600ms">
                                <div class="xb-item--inner">
                                    <div class="xb-item--holder">
                                        <ul class="xb-item--meta list-unstyled">
                                            <li>21 dec 2025</li>
                                            <li>business  tips</li>
                                        </ul>
                                        <h2 class="xb-item--title border-effect">
                                            <a href="blog-details.html">Driving your business forward with thoughtful advice..</a>
                                        </h2>
                                        <div class="xb-item--btn mt-120">
                                            <a class="thm-btn arrow_hover_effect" href="blog-details.html">
                                                <span class="btn_label" data-text="Read more blog">Read more blog</span>
                                                <span class="xb-icon">
                                                    <span class="xb-arrow">
                                                        <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                                        <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                        <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                                        <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                                        <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                                        <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                                        <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                                        <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                        </svg>
                                                        <svg width="30" height="29" viewBox="0 0 30 29" fill="none">
                                                        <rect x="6.25366" y="20.2163" width="21.557" height="2.73739" transform="rotate(-40.2798 6.25366 20.2163)" fill="#191B21" />
                                                        <rect x="9.29785" y="6.87241" width="2.73739" height="2.73739" transform="rotate(-40.2798 9.29785 6.87241)" fill="#191B21" />
                                                        <rect x="13.1558" y="7.19052" width="2.73739" height="2.73739" transform="rotate(-40.2798 13.1558 7.19052)" fill="#191B21" />
                                                        <rect x="17.0139" y="7.50897" width="2.73739" height="2.73739" transform="rotate(-40.2798 17.0139 7.50897)" fill="#191B21" />
                                                        <rect x="20.5535" y="11.6855" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.5535 11.6855)" fill="#191B21" />
                                                        <rect x="20.2356" y="15.5441" width="2.73739" height="2.73739" transform="rotate(-40.2798 20.2356 15.5441)" fill="#191B21" />
                                                        <rect x="19.9165" y="19.4021" width="2.73739" height="2.73739" transform="rotate(-40.2798 19.9165 19.4021)" fill="#191B21" />
                                                        </svg>
                                                    </span>
                                                </span>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="xb-item--img">
                                        <a href="blog-details.html">
                                            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/blog/img03.jpg" alt="image">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- blog end -->

    </main>
    <!-- main area end -->
	
	<?php
get_footer(); // This loads the footer
?>