<?php
/**
 * RankCrest Theme Functions
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}


/*--------------------------------------------------------------
# Theme Setup
--------------------------------------------------------------*/
function rankcrest_setup() {

    add_theme_support( 'title-tag' );
    add_theme_support( 'post-thumbnails' );
    add_theme_support( 'custom-logo', array(
        'height'      => 60,
        'width'       => 200,
        'flex-height' => true,
        'flex-width'  => true,
    ) );
    add_theme_support( 'html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    ) );

    register_nav_menus( array(
        'primary' => __( 'Primary Menu', 'rankcrest' ),
        'mobile'  => __( 'Mobile Menu', 'rankcrest' ),
        'footer'  => __( 'Footer Menu', 'rankcrest' ),
    ) );
}
add_action( 'after_setup_theme', 'rankcrest_setup' );


/*--------------------------------------------------------------
# Enqueue Styles & Scripts
--------------------------------------------------------------*/
function rankcrest_enqueue_assets() {

    $theme_version = wp_get_theme()->get('Version');
    $uri = get_template_directory_uri();

    /* --------------------
       CSS FILES
    ---------------------*/

    wp_enqueue_style('bootstrap', $uri . '/assets/css/bootstrap.min.css', array(), $theme_version);
    wp_enqueue_style('fontawesome', $uri . '/assets/css/fontawesome.css', array(), $theme_version);
    wp_enqueue_style('animate', $uri . '/assets/css/animate.css', array(), $theme_version);
    wp_enqueue_style('swiper', $uri . '/assets/css/swiper.min.css', array(), $theme_version);
    wp_enqueue_style('odometer', $uri . '/assets/css/odometer.css', array(), $theme_version);
    wp_enqueue_style('nice-select', $uri . '/assets/css/nice-select.css', array(), $theme_version);
    wp_enqueue_style('custom-fonts', $uri . '/assets/css/custom-fonts.css', array(), $theme_version);
    wp_enqueue_style('magnific-popup', $uri . '/assets/css/magnific-popup.css', array(), $theme_version);
    wp_enqueue_style('jquery-ui', $uri . '/assets/css/jquery-ui.css', array(), $theme_version);
    wp_enqueue_style('main-style', $uri . '/assets/css/main.css', array(), $theme_version);
    wp_enqueue_style('style', get_stylesheet_uri(), array(), $theme_version);


    /* --------------------
       JS FILES
    ---------------------*/

    wp_enqueue_script('jquery'); // WordPress default

    wp_enqueue_script('bootstrap', $uri . '/assets/js/bootstrap.bundle.min.js', array('jquery'), $theme_version, true);

    // Plugins
    wp_enqueue_script('swiper', $uri . '/assets/js/swiper.min.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('wow', $uri . '/assets/js/wow.min.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('appear', $uri . '/assets/js/appear.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('imagesloaded', $uri . '/assets/js/imagesloaded.pkgd.min.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('isotope', $uri . '/assets/js/isotope.pkgd.min.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('nice-select-js', $uri . '/assets/js/jquery.nice-select.min.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('marquee', $uri . '/assets/js/jquery.marquee.min.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('magnific-popup-js', $uri . '/assets/js/jquery.magnific-popup.min.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('jquery-ui-js', $uri . '/assets/js/jqueryui.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('touchspin', $uri . '/assets/js/touchspin.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('odometer-js', $uri . '/assets/js/odometer.min.js', array('jquery'), $theme_version, true);

    // Parallax & Effects
    wp_enqueue_script('parallax-scroll', $uri . '/assets/js/parallax-scroll.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('easing', $uri . '/assets/js/easing.min.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('scrollspy', $uri . '/assets/js/scrollspy.js', array('jquery'), $theme_version, true);

    // Special plugins
    wp_enqueue_script('plugin-js', $uri . '/assets/js/plugin.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('line-js', $uri . '/assets/js/line.js', array('jquery'), $theme_version, true);
    wp_enqueue_script('lenis', $uri . '/assets/js/lenis.js', array('jquery'), $theme_version, true);

    // Main script
    wp_enqueue_script('main-js', $uri . '/assets/js/main.js', array('jquery'), $theme_version, true);
}
add_action('wp_enqueue_scripts', 'rankcrest_enqueue_assets');



/*--------------------------------------------------------------
# Register Widget Areas
--------------------------------------------------------------*/
function rankcrest_widgets_init() {

    register_sidebar( array(
        'name'          => __( 'Footer Widget Area', 'rankcrest' ),
        'id'            => 'footer-1',
        'description'   => __( 'Widgets in the footer.', 'rankcrest' ),
        'before_widget' => '<div class="xb-footer_widget">',
        'after_widget'  => '</div>',
        'before_title'  => '<span class="xb-widget-title">',
        'after_title'   => '</span>',
    ) );

}
add_action( 'widgets_init', 'rankcrest_widgets_init' );


/*--------------------------------------------------------------
# Remove WordPress Junk from Head
--------------------------------------------------------------*/
remove_action( 'wp_head', 'rsd_link' );
remove_action( 'wp_head', 'wlwmanifest_link' );
remove_action( 'wp_head', 'wp_generator' );


/*--------------------------------------------------------------
# Excerpt Length
--------------------------------------------------------------*/
function rankcrest_excerpt_length( $length ) {
    return 20;
}
add_filter( 'excerpt_length', 'rankcrest_excerpt_length' );

